package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.RequestMetrics;
import com.atlassian.vcache.internal.core.Instrumentor;

/**
 * Provides the ability to collect and obtain metrics at the {@link RequestContext} level.
 * <p>
 * Provides methods to:
 * </p>
 * <ul>
 * <li>Record a sample - {@link #record(String, CacheType, MetricLabel, long)}</li>
 * <li>Obtain the request metrics {@link #obtainRequestMetrics(RequestContext)}</li>
 * <li>Wrap an entity for collecting metrics - see the {@code wrap(...)} methods</li>
 * </ul>
 *
 * @since 1.0.0
 */
public interface MetricsCollector extends Instrumentor, MetricsRecorder {
    RequestMetrics obtainRequestMetrics(RequestContext requestContext);
}
