package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.vcache.internal.JsonableFactory;
import com.atlassian.vcache.internal.RequestMetrics;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Implementation of {@link JsonableFactory} that uses the Google Gson library.
 *
 * @since 1.0.0
 */
public class GsonJsonableFactory implements JsonableFactory {
    // Gson is multi-thread safe
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public Jsonable apply(final RequestMetrics requestMetrics) {
        return writer -> writer.write(GSON.toJson(requestMetrics));
    }
}
