package com.atlassian.vcache.internal.core.metrics;

import java.util.function.LongConsumer;

import static java.util.Objects.requireNonNull;

/**
 * Utility timer for measuring the elapsed time using {@link System#nanoTime()}. Timing is started when the
 * instance is created, and stopped when {@link #close()} is called.
 *
 * @since 1.0.0
 */
public class ElapsedTimer implements AutoCloseable {
    private final long startTime;
    private final LongConsumer handler;

    /**
     * Create an instance with a handler to be called with the total elapsed time.
     *
     * @param handler called when the timer has been closed.
     */
    public ElapsedTimer(LongConsumer handler) {
        this.startTime = System.nanoTime();
        this.handler = requireNonNull(handler);
    }

    @Override
    public void close() {
        handler.accept(System.nanoTime() - startTime);
    }
}
