package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.LongMetric;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestMetrics;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Default implementation of {@link RequestMetrics}.
 *
 * @since 1.0.0
 */
class DefaultRequestMetrics implements MutableRequestMetrics, RequestMetrics {
    private final Map<CacheType, Map<String, Map<MetricLabel, DefaultLongMetric>>> allMetricsMap =
            Collections.synchronizedMap(new EnumMap<>(CacheType.class));

    @Override
    public void record(String cacheName, CacheType cacheType, MetricLabel metricLabel, long sample) {
        final Map<String, Map<MetricLabel, DefaultLongMetric>> cacheTypeMetricsMap =
                allMetricsMap.computeIfAbsent(cacheType, k -> new ConcurrentHashMap<>());

        final Map<MetricLabel, DefaultLongMetric> cacheMetricsMap =
                cacheTypeMetricsMap.computeIfAbsent(cacheName, k -> Collections.synchronizedMap(new EnumMap<>(MetricLabel.class)));

        final DefaultLongMetric metric = cacheMetricsMap.computeIfAbsent(metricLabel, k -> new DefaultLongMetric());
        metric.record(sample);
    }

    @Override
    @SuppressWarnings("unchecked")
    public Map<String, Map<MetricLabel, ? extends LongMetric>> allJvmCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.JVM, k -> new ConcurrentHashMap<>()));
    }

    @Override
    @SuppressWarnings("unchecked")
    public Map<String, Map<MetricLabel, ? extends LongMetric>> allRequestCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.REQUEST, k -> new ConcurrentHashMap<>()));
    }

    @Override
    @SuppressWarnings("unchecked")
    public Map<String, Map<MetricLabel, ? extends LongMetric>> allExternalCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.EXTERNAL, k -> new ConcurrentHashMap<>()));
    }
}
