package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.workcontext.api.ImmutableWorkContextReference;

import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link Supplier} for {@link RequestContext} that provides a structure that will
 * be available and safe to use in a WorkContext.
 * <p>
 * @since 1.6.0
 */
public class WorkContextRequestContextSupplier implements Supplier<RequestContext> {
    private ImmutableWorkContextReference<RequestContext> requestContextSupplier;

    /**
     * Build the {@link Supplier} and provide it with a supplier for the partitionIdentifier.
     *
     * @param partitionIdentifier A {@link Supplier} that provides the current partitionIdentifier.
     */
    public WorkContextRequestContextSupplier(Supplier<String> partitionIdentifier) {
        requireNonNull(partitionIdentifier);
        this.requestContextSupplier = new ImmutableWorkContextReference<>(() -> new DefaultRequestContext(partitionIdentifier));
    }

    @Override
    public RequestContext get() {
        return requestContextSupplier.get();
    }
}