package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestContext;

import java.util.Set;

/**
 * Provides tracking of transactional resources that need to be synchronised.
 *
 * @since 1.0.0
 */
public interface TransactionControlManager {
    /**
     * Register a {@link com.atlassian.vcache.TransactionalExternalCache} for synchronisation.
     *
     * @param requestContext the context for tracking
     * @param cacheName      the name of cache to be registered
     * @param control        the control used to synchronise the cache.
     */
    void registerTransactionalExternalCache(RequestContext requestContext, String cacheName, TransactionControl control);

    /**
     * Synchronises all the resources previously registered using {@link #registerTransactionalExternalCache(RequestContext, String, TransactionControl)}.
     *
     * @param requestContext the context used for tracking
     */
    void syncAll(RequestContext requestContext);

    /**
     * Discards all the resources previously registered using {@link #registerTransactionalExternalCache(RequestContext, String, TransactionControl)}.
     *
     * @param requestContext the context used for tracking
     * @return names of the caches that have operations being discarded.
     */
    Set<String> discardAll(RequestContext requestContext);
}
