/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.LocalCacheOperations;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

abstract class TimedLocalCacheOperations<K, V>
implements LocalCacheOperations<K, V> {
    protected final String cacheName;
    protected final CacheType cacheType;
    protected final MetricsCollector metricsCollector;

    TimedLocalCacheOperations(String cacheName, CacheType cacheType, MetricsCollector metricsCollector) {
        this.cacheName = Objects.requireNonNull(cacheName);
        this.cacheType = Objects.requireNonNull(cacheType);
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
    }

    @Nonnull
    protected abstract LocalCacheOperations<K, V> getDelegate();

    @Nonnull
    public Optional<V> get(K key) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_GET_CALL, t));){
            Optional result = this.getDelegate().get(key);
            this.metricsCollector.record(this.cacheType, this.cacheName, result.isPresent() ? MetricLabel.NUMBER_OF_HITS : MetricLabel.NUMBER_OF_MISSES, 1L);
            Optional optional = result;
            return optional;
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(K key, V value) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_PUT_CALL, t));){
            this.getDelegate().put(key, value);
        }
    }

    @Nonnull
    public Optional<V> putIfAbsent(K key, V value) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_PUT_CALL, t));){
            Optional optional = this.getDelegate().putIfAbsent(key, value);
            return optional;
        }
    }

    public boolean replaceIf(K key, V currentValue, V newValue) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_PUT_CALL, t));){
            boolean bl = this.getDelegate().replaceIf(key, currentValue, newValue);
            return bl;
        }
    }

    public boolean removeIf(K key, V value) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_REMOVE_CALL, t));){
            boolean bl = this.getDelegate().removeIf(key, value);
            return bl;
        }
    }

    public void remove(K key) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_REMOVE_CALL, t));){
            this.getDelegate().remove(key);
        }
    }

    public void removeAll() {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_REMOVE_ALL_CALL, t));){
            this.getDelegate().removeAll();
        }
    }

    private void handleTimedSupplier(Optional<Long> time) {
        if (time.isPresent()) {
            this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_SUPPLIER_CALL, time.get());
        }
        this.metricsCollector.record(this.cacheType, this.cacheName, time.isPresent() ? MetricLabel.NUMBER_OF_MISSES : MetricLabel.NUMBER_OF_HITS, 1L);
    }

    private /* synthetic */ void lambda$get$1(long t) {
        this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_GET_CALL, t);
    }
}

