/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.ExternalCache;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.TimedFactory;
import com.atlassian.vcache.internal.core.metrics.TimedUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

abstract class TimedExternalCache<V>
implements ExternalCache<V> {
    protected final MetricsCollector metricsCollector;

    TimedExternalCache(MetricsCollector metricsCollector) {
        this.metricsCollector = Objects.requireNonNull(metricsCollector);
    }

    @Nonnull
    protected abstract ExternalCache<V> getDelegate();

    @Nonnull
    public CompletionStage<Optional<V>> get(String key) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().get(key);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_GET, 1L);
                } else {
                    Optional rj = (Optional)future.join();
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), rj.isPresent() ? MetricLabel.NUMBER_OF_HITS : MetricLabel.NUMBER_OF_MISSES, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public CompletionStage<V> get(String key, Supplier<V> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<V>>> getBulk(Iterable<String> keys) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().getBulk(keys);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_GET, 1L);
                } else {
                    Map rj = (Map)future.join();
                    long hits = rj.values().stream().filter(Optional::isPresent).count();
                    VCacheCoreUtils.whenPositive(hits, v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_HITS, v));
                    VCacheCoreUtils.whenPositive((long)rj.size() - hits, v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_MISSES, v));
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public CompletionStage<Map<String, V>> getBulk(Function<Set<String>, Map<String, V>> factory, Iterable<String> keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public String getName() {
        return this.getDelegate().getName();
    }

    private void handleTimedSupplier(Optional<Long> time) {
        if (time.isPresent()) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_SUPPLIER_CALL, time.get());
        }
        this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), time.isPresent() ? MetricLabel.NUMBER_OF_MISSES : MetricLabel.NUMBER_OF_HITS, 1L);
    }

    private void handleTimedFactory(Optional<Long> time, Long numberOfKeys) {
        if (time.isPresent()) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_FACTORY_CALL, time.get());
            this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FACTORY_KEYS, numberOfKeys);
        }
    }

    private /* synthetic */ void lambda$getBulk$11(TimedFactory timedFactory, CompletableFuture future) {
        if (future.isCompletedExceptionally()) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_GET, 1L);
        } else {
            Map rj = (Map)future.join();
            VCacheCoreUtils.whenPositive((long)rj.size() - timedFactory.getNumberOfKeys(), v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_HITS, v));
            VCacheCoreUtils.whenPositive(timedFactory.getNumberOfKeys(), v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_MISSES, v));
        }
    }

    private /* synthetic */ void lambda$getBulk$8(long t) {
        this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_GET_CALL, t);
    }

    private /* synthetic */ void lambda$get$3(CompletableFuture future) {
        if (future.isCompletedExceptionally()) {
            this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_GET, 1L);
        }
    }

    private /* synthetic */ void lambda$get$2(long t) {
        this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_GET_CALL, t);
    }
}

