/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DefaultRequestContext
implements RequestContext {
    private final String partitionId;
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();

    public DefaultRequestContext(String partitionId) {
        this.partitionId = Objects.requireNonNull(partitionId);
    }

    @Nonnull
    public String partitionIdentifier() {
        return this.partitionId;
    }

    @Nonnull
    public <T> T computeIfAbsent(Object key, Supplier<T> supplier) {
        return (T)this.map.computeIfAbsent(Objects.requireNonNull(key), (? super K o) -> Objects.requireNonNull(supplier.get()));
    }

    @Nonnull
    public <T> Optional<T> get(Object key) {
        return Optional.ofNullable(this.map.get(key));
    }
}

