/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.TimedLocalCacheOperations;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

class TimedJvmCache<K, V>
extends TimedLocalCacheOperations<K, V>
implements JvmCache<K, V> {
    private final JvmCache<K, V> delegate;

    TimedJvmCache(JvmCache<K, V> delegate, MetricsCollector metricsCollector) {
        super(delegate.getName(), CacheType.JVM, metricsCollector);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    @Nonnull
    protected JvmCache<K, V> getDelegate() {
        return this.delegate;
    }

    @Nonnull
    public Set<K> getKeys() {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(this.cacheType, this.cacheName, MetricLabel.TIMED_GET_KEYS_CALL, t));){
            Set set = this.delegate.getKeys();
            return set;
        }
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }
}

