package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;

import javax.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Supplier;

/**
 * Represents the request context for an {@link com.atlassian.vcache.ExternalCache} that maintains a
 * cache version.
 *
 * @param <V> the value type
 * @since 1.0.0
 */
public class VersionedExternalCacheRequestContext<V> extends AbstractExternalCacheRequestContext<V> {
    protected final String externalCacheVersionKey;
    private Optional<Long> cacheVersion = Optional.empty();

    public VersionedExternalCacheRequestContext(ExternalCacheKeyGenerator keyGenerator,
                                                String name,
                                                Supplier<String> partitionSupplier) {
        super(keyGenerator, name, partitionSupplier);
        this.externalCacheVersionKey =
                keyGenerator.cacheVersionKey(partitionSupplier.get(), name);
    }

    @Override
    protected long cacheVersion() {
        return cacheVersion.get();
    }

    public void updateCacheVersion(long value) {
        cacheVersion = Optional.of(value);
        clearKeyMaps();
    }

    @Nonnull
    public String externalCacheVersionKey() {
        return externalCacheVersionKey;
    }
}
