package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.StableReadExternalCache;

import javax.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * Provides operations common to {@link com.atlassian.vcache.StableReadExternalCache} instances.
 *
 * @param <V> the value type
 * @since 1.0.0
 */
public abstract class AbstractStableReadExternalCache<V>
        extends AbstractNonDirectExternalCache<V>
        implements StableReadExternalCache<V> {
    protected AbstractStableReadExternalCache(String name) {
        super(name);
    }

    @Nonnull
    protected final Optional<Optional<V>> checkValueRecorded(String internalKey) {
        return ensureCacheContext().getValueRecorded(internalKey);
    }

    @Nonnull
    protected final Map<String, Optional<V>> checkValuesRecorded(Iterable<String> internalKeys) {
        final AbstractExternalCacheRequestContext<V> cacheContext = ensureCacheContext();
        return StreamSupport.stream(internalKeys.spliterator(), false)
                .filter(k -> cacheContext.getValueRecorded(k).isPresent())
                .distinct()
                .collect(Collectors.toMap(
                                k -> k,
                                k -> cacheContext.getValueRecorded(k).get())
                );
    }
}
