package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.core.TransactionControl;

import static com.atlassian.vcache.internal.MetricLabel.TIMED_TRANSACTION_DISCARD_CALL;
import static com.atlassian.vcache.internal.MetricLabel.TIMED_TRANSACTION_SYNC_CALL;
import static java.util.Objects.requireNonNull;

/**
 * Wrapper for a {@link TransactionControl} that records metrics.
 *
 * @since 1.0.0
 */
class TimedTransactionControl implements TransactionControl {
    private final TransactionControl delegate;
    private final MetricsCollector metricsCollector;
    private final String cacheName;

    TimedTransactionControl(TransactionControl delegate, MetricsCollector metricsCollector, String cacheName) {
        this.delegate = requireNonNull(delegate);
        this.metricsCollector = requireNonNull(metricsCollector);
        this.cacheName = requireNonNull(cacheName);
    }

    @Override
    public void transactionSync() {
        try (ElapsedTimer ignored = new ElapsedTimer(
                t -> metricsCollector.record(CacheType.EXTERNAL, cacheName, TIMED_TRANSACTION_SYNC_CALL, t))) {
            delegate.transactionSync();
        }
    }

    @Override
    public boolean transactionDiscard() {
        try (ElapsedTimer ignored = new ElapsedTimer(
                t -> metricsCollector.record(CacheType.EXTERNAL, cacheName, TIMED_TRANSACTION_DISCARD_CALL, t))) {
            return delegate.transactionDiscard();
        }
    }
}
