package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.ExternalCache;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.StableReadExternalCache;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Wrapper for a {@link StableReadExternalCache} that records metrics.
 *
 * @param <V> the value type
 * @since 1.0.0
 */
class TimedStableReadExternalCache<V>
        extends TimedExternalWriteOperationsUnbuffered<V>
        implements StableReadExternalCache<V> {
    private final StableReadExternalCache<V> delegate;

    TimedStableReadExternalCache(MetricsCollector metricsCollector, StableReadExternalCache<V> delegate) {
        super(metricsCollector);
        this.delegate = requireNonNull(delegate);
    }

    @Nonnull
    @Override
    protected ExternalWriteOperationsUnbuffered<V> getDelegateOps() {
        return delegate;
    }

    @Nonnull
    @Override
    protected ExternalCache<V> getDelegate() {
        return delegate;
    }
}
