package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.internal.MetricLabel;

import javax.annotation.Nonnull;
import java.util.Set;

import static java.util.Objects.requireNonNull;

/**
 * Wrapper for a {@link JvmCache} that records metrics.
 *
 * @param <K> the key type
 * @param <V> the value type
 * @since 1.0.0
 */
class TimedJvmCache<K, V>
        extends TimedLocalCacheOperations<K, V>
        implements JvmCache<K, V> {
    private final JvmCache<K, V> delegate;

    TimedJvmCache(JvmCache<K, V> delegate, MetricsCollector metricsCollector) {
        super(delegate.getName(), CacheType.JVM, metricsCollector);
        this.delegate = requireNonNull(delegate);
    }

    @Nonnull
    @Override
    protected JvmCache<K, V> getDelegate() {
        return delegate;
    }

    @Nonnull
    @Override
    public Set<K> getKeys() {
        try (ElapsedTimer ignored = new ElapsedTimer(
                t -> metricsCollector.record(cacheType, cacheName, MetricLabel.TIMED_GET_KEYS_CALL, t))) {
            return delegate.getKeys();
        }
    }

    @Nonnull
    @Override
    public String getName() {
        return delegate.getName();
    }
}
