package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.RequestMetrics;
import com.atlassian.vcache.internal.core.TransactionControl;

import javax.annotation.Nonnull;

/**
 * An implementation of {@link MetricsCollector} that collects nothing.
 *
 * @since 1.0.0
 */
public class NoopMetricsCollector implements MetricsCollector {
    @Override
    public void record(CacheType cacheType, String cacheName, MetricLabel metricLabel, long sample) {
    }

    @Nonnull
    @Override
    public RequestMetrics obtainRequestMetrics(RequestContext requestContext) {
        return new EmptyRequestMetrics();
    }

    @Nonnull
    @Override
    public TransactionControl wrap(TransactionControl control, String cacheName) {
        return control;
    }

    @Nonnull
    @Override
    public <T> Marshaller<T> wrap(Marshaller<T> marshaller, String cacheName) {
        return marshaller;
    }

    @Nonnull
    @Override
    public <K, V> JvmCache<K, V> wrap(JvmCache<K, V> cache) {
        return cache;
    }

    @Nonnull
    @Override
    public <K, V> RequestCache<K, V> wrap(RequestCache<K, V> cache) {
        return cache;
    }

    @Nonnull
    @Override
    public <V> DirectExternalCache<V> wrap(DirectExternalCache<V> cache) {
        return cache;
    }

    @Nonnull
    @Override
    public <V> StableReadExternalCache<V> wrap(StableReadExternalCache<V> cache) {
        return cache;
    }

    @Nonnull
    @Override
    public <V> TransactionalExternalCache<V> wrap(TransactionalExternalCache<V> cache) {
        return cache;
    }
}
