package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.vcache.internal.JsonableFactory;
import com.atlassian.vcache.internal.RequestMetrics;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;

import javax.annotation.Nonnull;

/**
 * Implementation of {@link JsonableFactory} that uses the Jackson library.
 *
 * @since 1.0.0
 */
public class JacksonJsonableFactory implements JsonableFactory {
    // ObjectMapper is thread safe
    private static final ObjectMapper OBJECT_MAPPER;

    static {
        final ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        OBJECT_MAPPER = mapper;
    }

    @Override
    @Nonnull
    public Jsonable apply(final RequestMetrics requestMetrics) {
        return writer -> OBJECT_MAPPER.writeValue(writer, requestMetrics);
    }
}
