package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.LongMetric;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestMetrics;

import javax.annotation.Nonnull;
import java.util.EnumMap;
import java.util.Map;

import static java.util.Collections.emptyMap;

/**
 * An implementation of {@link RequestMetrics} that has nothing.
 *
 * @since 1.0.0
 */
public class EmptyRequestMetrics implements RequestMetrics {
    @Nonnull
    @Override
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allJvmCacheLongMetrics() {
        return emptyMap();
    }

    @Nonnull
    @Override
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allRequestCacheLongMetrics() {
        return emptyMap();
    }

    @Nonnull
    @Override
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allExternalCacheLongMetrics() {
        return emptyMap();
    }
}
