package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.LongMetric;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestMetrics;

import javax.annotation.Nonnull;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/**
 * Default implementation of {@link RequestMetrics}.
 *
 * @since 1.0.0
 */
class DefaultRequestMetrics implements MutableRequestMetrics, RequestMetrics {
    private final EnumMap<CacheType, Map<String, EnumMap<MetricLabel, DefaultLongMetric>>> allMetricsMap =
            new EnumMap<>(CacheType.class);

    @Override
    public void record(String cacheName, CacheType cacheType, MetricLabel metricLabel, long sample) {
        final Map<String, EnumMap<MetricLabel, DefaultLongMetric>> cacheTypeMetricsMap =
                allMetricsMap.computeIfAbsent(cacheType, k -> new HashMap<>());

        final EnumMap<MetricLabel, DefaultLongMetric> cacheMetricsMap =
                cacheTypeMetricsMap.computeIfAbsent(cacheName, k -> new EnumMap<>(MetricLabel.class));

        final DefaultLongMetric metric = cacheMetricsMap.computeIfAbsent(metricLabel, k -> new DefaultLongMetric());
        metric.record(sample);
    }

    @Nonnull
    @Override
    @SuppressWarnings("unchecked")
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allJvmCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.JVM, k -> new HashMap<>()));
    }

    @Nonnull
    @Override
    @SuppressWarnings("unchecked")
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allRequestCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.REQUEST, k -> new HashMap<>()));
    }

    @Nonnull
    @Override
    @SuppressWarnings("unchecked")
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allExternalCacheLongMetrics() {
        return new HashMap(allMetricsMap.computeIfAbsent(CacheType.EXTERNAL, k -> new HashMap<>()));
    }
}
