package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.LongMetric;

/**
 * Implementation of the {@link LongMetric} interface that is <b>NOT</b> multi-thread safe.
 *
 * @since 1.0.0
 */
public class DefaultLongMetric implements LongMetric {
    private long sampleCount;
    private long samplesTotal;
    private long minSample = Long.MAX_VALUE;
    private long maxSample = Long.MIN_VALUE;

    /**
     * Records a sample.
     *
     * @param sample the sample to be recorded
     */
    public void record(long sample) {
        sampleCount++;
        samplesTotal += sample;
        minSample = Math.min(sample, minSample);
        maxSample = Math.max(sample, maxSample);
    }

    @Override
    public long getSampleCount() {
        return sampleCount;
    }

    @Override
    public long getSamplesTotal() {
        return samplesTotal;
    }

    @Override
    public long getMinSample() {
        return minSample;
    }

    @Override
    public long getMaxSample() {
        return maxSample;
    }
}
