package com.atlassian.vcache.internal.core.cas;

import java.util.Arrays;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link IdentifiedData} that holds an array of bytes.
 *
 * @since 1.1.0
 */
public class IdentifiedDataBytes extends IdentifiedData {
    private final byte[] bytes;

    public IdentifiedDataBytes(byte[] bytes) {
        this.bytes = requireNonNull(bytes);
    }

    public byte[] getBytes() {
        return bytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifiedDataBytes)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        final IdentifiedDataBytes that = (IdentifiedDataBytes) o;

        return Arrays.equals(bytes, that.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(bytes);
    }
}
