package com.atlassian.vcache.internal.core.cas;

import com.atlassian.vcache.CasIdentifier;

import java.io.Serializable;

/**
 * Implementation of {@link CasIdentifier} that uses current time as the unique identifier.
 *
 * @since 1.1.0
 */
public class IdentifiedData implements Serializable, CasIdentifier {
    // Using nano time to create a "unique" identifier. See NOTED.md file for more.
    private final long casId = System.nanoTime();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifiedData)) {
            return false;
        }

        final IdentifiedData that = (IdentifiedData) o;

        return casId == that.casId;
    }
}
