package com.atlassian.vcache.internal.core;

import javax.annotation.Nonnull;

/**
 * Implementation of {@link ExternalCacheKeyGenerator} that does not do any encoding. Useful for testing purposes.
 *
 * @since 1.0.0
 */
public class PlainExternalCacheKeyGenerator extends ExternalCacheKeyGenerator {
    public PlainExternalCacheKeyGenerator(String productIdentifier) {
        super(productIdentifier);
    }

    @Nonnull
    @Override
    protected String encode(String plain) {
        return plain;
    }
}
