package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;

import javax.annotation.Nonnull;

/**
 * Provides methods to wrap standard VCache types for instrumentation.
 *
 * @since 1.0.0
 */
public interface Instrumentor {
    @Nonnull
    TransactionControl wrap(TransactionControl control, String cacheName);

    @Nonnull
    <T> Marshaller<T> wrap(Marshaller<T> marshaller, String cacheName);

    @Nonnull
    <K, V> JvmCache<K, V> wrap(JvmCache<K, V> cache);

    @Nonnull
    <K, V> RequestCache<K, V> wrap(RequestCache<K, V> cache);

    @Nonnull
    <V> DirectExternalCache<V> wrap(DirectExternalCache<V> cache);

    @Nonnull
    <V> StableReadExternalCache<V> wrap(StableReadExternalCache<V> cache);

    @Nonnull
    <V> TransactionalExternalCache<V> wrap(TransactionalExternalCache<V> cache);
}
