package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.internal.JvmCacheDetails;

import static java.util.Objects.requireNonNull;

/**
 * Default immutable implementation of {@link JvmCacheDetails}.
 *
 * @since 1.0.0
 */
public class DefaultJvmCacheDetails implements JvmCacheDetails {
    private final String name;
    private final JvmCacheSettings settings;

    public DefaultJvmCacheDetails(@SuppressWarnings("LocalCanBeFinal") String name, @SuppressWarnings("LocalCanBeFinal") JvmCacheSettings settings) {
        this.name = requireNonNull(name);
        this.settings = requireNonNull(settings);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public JvmCacheSettings getSettings() {
        return settings;
    }
}
