package com.atlassian.vcache.internal.core.metrics;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

/**
 * Provides helper methods for the timed wrappers.
 *
 * @since 1.0.0
 */
class TimedUtils {
    static <T> void whenCompletableFuture(CompletionStage<T> stage, Consumer<CompletableFuture<T>> handle) {
        if (stage instanceof CompletableFuture) {
            handle.accept((CompletableFuture<T>) stage);
        }
    }
}
