package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.ExternalCache;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.StableReadExternalCache;

import static java.util.Objects.requireNonNull;

/**
 * Wrapper for a {@link StableReadExternalCache} that records metrics.
 *
 * @param <V> the value type
 * @since 1.0.0
 */
class TimedStableReadExternalCache<V>
        extends TimedExternalWriteOperationsUnbuffered<V>
        implements StableReadExternalCache<V> {
    private final StableReadExternalCache<V> delegate;

    TimedStableReadExternalCache(MetricsRecorder metricsRecorder, StableReadExternalCache<V> delegate) {
        super(metricsRecorder);
        this.delegate = requireNonNull(delegate);
    }

    @Override
    protected ExternalWriteOperationsUnbuffered<V> getDelegateOps() {
        return delegate;
    }

    @Override
    protected ExternalCache<V> getDelegate() {
        return delegate;
    }
}
