package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestContext;

import java.util.function.Predicate;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Metrics collector that collects metrics only for specified requests.
 *
 * @since 1.4.0
 */
public class SamplingMetricsCollector extends DefaultMetricsCollector {

    private static final NoOpRequestMetrics NOOP_REQUEST_METRICS = new NoOpRequestMetrics();

    private final Predicate<RequestContext> collectMetrics;

    public SamplingMetricsCollector(
            Supplier<RequestContext> contextSupplier,
            Predicate<RequestContext> collectMetrics) {
        super(contextSupplier);
        this.collectMetrics = requireNonNull(collectMetrics);
    }

    @Override
    protected MutableRequestMetrics obtainMetrics(RequestContext context) {
        return context.computeIfAbsent(this, () ->
                collectMetrics.test(context) ? new DefaultRequestMetrics() : NOOP_REQUEST_METRICS);
    }

    private static class NoOpRequestMetrics extends EmptyRequestMetrics implements MutableRequestMetrics {
        @Override
        public void record(String cacheName, CacheType cacheType, MetricLabel metricLabel, long sample) {
            // do nothing
        }
    }
}
