package com.atlassian.vcache.internal.core.cas;

import java.io.Serializable;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link IdentifiedData} that hold a {@link Serializable} object.
 *
 * @since 1.1.0
 */
public class IdentifiedDataSerializable extends IdentifiedData {
    private final Serializable object;

    public IdentifiedDataSerializable(Serializable object) {
        this.object = requireNonNull(object);
    }

    public Serializable getObject() {
        return object;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifiedDataSerializable)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        final IdentifiedDataSerializable that = (IdentifiedDataSerializable) o;

        return object.equals(that.object);
    }

    @Override
    public int hashCode() {
        return object.hashCode();
    }
}
