package com.atlassian.vcache.internal.core;

/**
 * Interface for controlling the transaction characteristics of an entity.
 *
 * @since 1.0
 */
public interface TransactionControl {
    /**
     * Synchronize any changes.
     */
    void transactionSync();

    /**
     * Discard any changes.
     * @return whether any changes were discarded.
     */
    boolean transactionDiscard();
}
