package com.atlassian.vcache.internal.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link ExternalCacheKeyGenerator} that logs at <tt>debug</tt> level the key before and after.
 *
 * @since 1.0.0
 */
public class LoggingExternalCacheKeyGenerator extends ExternalCacheKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(LoggingExternalCacheKeyGenerator.class);

    private final ExternalCacheKeyGenerator delegate;

    public LoggingExternalCacheKeyGenerator(String productIdentifier, ExternalCacheKeyGenerator delegate) {
        super(productIdentifier);
        this.delegate = requireNonNull(delegate);
    }

    @Override
    protected String encode(String plain) {
        final String result = delegate.encode(plain);
        log.debug("Generated key {} from {}", result, plain);
        return result;
    }
}
