package com.atlassian.vcache.internal.core;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;

/**
 * Provides methods to wrap standard VCache types for instrumentation.
 *
 * @since 1.0.0
 */
public interface Instrumentor {
    TransactionControl wrap(TransactionControl control, String cacheName);

    <T> MarshallingPair<T> wrap(MarshallingPair<T> marshalling, String cacheName);

    <K, V> JvmCache<K, V> wrap(JvmCache<K, V> cache);

    <K, V> RequestCache<K, V> wrap(RequestCache<K, V> cache);

    <V> DirectExternalCache<V> wrap(DirectExternalCache<V> cache);

    <V> StableReadExternalCache<V> wrap(StableReadExternalCache<V> cache);

    <V> TransactionalExternalCache<V> wrap(TransactionalExternalCache<V> cache);
}
