package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestContext;

import javax.annotation.Nullable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * An implementation of the {@link RequestContext}.
 *
 * @since 1.0
 */
public class DefaultRequestContext implements RequestContext {
    @Nullable
    private String partitionId;
    private final Supplier<String> partitionIdSupplier;
    private final Map<Object, Object> map = new ConcurrentHashMap<>();

    public DefaultRequestContext(Supplier<String> partitionIdSupplier) {
        this.partitionIdSupplier = requireNonNull(partitionIdSupplier);
    }

    @Override
    public String partitionIdentifier() {
        // It doesn't matter if multiple threads get the value from the supplier, it should be a relatively cheap call
        // and it should always return the same value.
        if (partitionId == null) {
            partitionId = partitionIdSupplier.get();
        }
        return partitionId;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T computeIfAbsent(Object key, Supplier<T> supplier) {
        return (T) map.computeIfAbsent(requireNonNull(key), o -> requireNonNull(supplier.get()));
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> Optional<T> get(Object key) {
        return Optional.ofNullable((T) map.get(key));
    }
}
