package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestCacheDetails;

import static java.util.Objects.requireNonNull;

/**
 * Default immutable implementation of {@link RequestCacheDetails}.
 *
 * @since 1.0.0
 */
public class DefaultRequestCacheDetails implements RequestCacheDetails {
    private final String name;

    public DefaultRequestCacheDetails(String name) {
        this.name = requireNonNull(name);
    }

    @Override
    public String getName() {
        return name;
    }
}
