package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.IdentifiedValue;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of {@link IdentifiedValue}
 *
 * @param <T> the value type
 * @since 1.0.0
 */
public class DefaultIdentifiedValue<T> implements IdentifiedValue<T> {
    private final CasIdentifier identifier;
    private final T value;

    public DefaultIdentifiedValue(CasIdentifier identifier, T value) {
        this.identifier = requireNonNull(identifier);
        this.value = requireNonNull(value);
    }

    @Override
    public CasIdentifier identifier() {
        return identifier;
    }

    @Override
    public T value() {
        return value;
    }

    @Override
    public String toString() {
        return "DefaultIdentifiedValue{" +
                "identifier=" + identifier +
                ", value=" + value +
                '}';
    }
}
