package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.internal.ExternalCacheDetails;

import static java.util.Objects.requireNonNull;

/**
 * Default immutable implementation of {@link ExternalCacheDetails}.
 *
 * @since 1.0.0
 */
public class DefaultExternalCacheDetails implements ExternalCacheDetails {
    private final String name;
    private final BufferPolicy policy;
    private final ExternalCacheSettings settings;

    public DefaultExternalCacheDetails(String name, BufferPolicy policy, ExternalCacheSettings settings) {
        this.name = requireNonNull(name);
        this.policy = requireNonNull(policy);
        this.settings = requireNonNull(settings);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public BufferPolicy getPolicy() {
        return policy;
    }

    @Override
    public ExternalCacheSettings getSettings() {
        return settings;
    }
}
