/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.metrics.TimedExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.internal.core.metrics.TimedSupplier;
import com.atlassian.vcache.internal.core.metrics.TimedUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

class TimedDirectExternalCache<V>
extends TimedExternalWriteOperationsUnbuffered<V>
implements DirectExternalCache<V> {
    private final DirectExternalCache<V> delegate;

    TimedDirectExternalCache(MetricsRecorder metricsRecorder, DirectExternalCache<V> delegate) {
        super(metricsRecorder);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    protected ExternalWriteOperationsUnbuffered<V> getDelegateOps() {
        return this.delegate;
    }

    @Override
    protected DirectExternalCache<V> getDelegate() {
        return this.delegate;
    }

    public CompletionStage<Optional<IdentifiedValue<V>>> getIdentified(String key) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.TIMED_IDENTIFIED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().getIdentified(key);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_GET, 1L);
                } else {
                    Optional rj = (Optional)future.join();
                    this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, rj.isPresent() ? MetricLabel.NUMBER_OF_HITS : MetricLabel.NUMBER_OF_MISSES, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    /*
     * Exception decompiling
     */
    public CompletionStage<IdentifiedValue<V>> getIdentified(String key, Supplier<V> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompletionStage<Map<String, Optional<IdentifiedValue<V>>>> getBulkIdentified(Iterable<String> keys) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.TIMED_IDENTIFIED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().getBulkIdentified(keys);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_GET, 1L);
                } else {
                    Map rj = (Map)future.join();
                    long hits = rj.values().stream().filter(Optional::isPresent).count();
                    VCacheCoreUtils.whenPositive(hits, v -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_HITS, v));
                    VCacheCoreUtils.whenPositive((long)rj.size() - hits, v -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_MISSES, v));
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    public CompletionStage<Boolean> removeIf(String key, CasIdentifier casId) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.TIMED_IDENTIFIED_REMOVE_CALL, t));){
            CompletionStage result = this.getDelegate().removeIf(key, casId);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_REMOVE, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    public CompletionStage<Boolean> replaceIf(String key, CasIdentifier casId, V newValue) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.TIMED_IDENTIFIED_REPLACE_CALL, t));){
            CompletionStage result = this.getDelegate().replaceIf(key, casId, newValue);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_REPLACE, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    private /* synthetic */ void lambda$getIdentified$3(TimedSupplier timedSupplier, CompletableFuture future) {
        if (future.isCompletedExceptionally()) {
            this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_GET, 1L);
        } else {
            this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, timedSupplier.wasInvoked() ? MetricLabel.NUMBER_OF_MISSES : MetricLabel.NUMBER_OF_HITS, 1L);
        }
    }

    private /* synthetic */ void lambda$getIdentified$2(long t) {
        this.metricsRecorder.record(this.getDelegate().getName(), CacheType.EXTERNAL, MetricLabel.TIMED_IDENTIFIED_GET_CALL, t);
    }
}

