package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;

import java.time.Duration;
import java.util.function.Supplier;

/**
 * Represents the request context for an {@link com.atlassian.vcache.ExternalCache} that does not maintain a
 * cache version.
 *
 * @param <V> the value type
 * @since 1.0.0
 */
public class UnversionedExternalCacheRequestContext<V> extends AbstractExternalCacheRequestContext<V> {
    private static final long FIXED_CACHE_VERSION = 200106074;

    public UnversionedExternalCacheRequestContext(
            ExternalCacheKeyGenerator keyGenerator,
            String name,
            Supplier<String> partitionSupplier,
            Duration lockTimeout) {
        super(keyGenerator, name, partitionSupplier, lockTimeout);
    }

    @Override
    protected final long cacheVersion() {
        return FIXED_CACHE_VERSION;
    }
}
