package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.VCacheException;

import java.util.Map;
import java.util.Set;

/**
 * Provides common functionality for factories.
 *
 * @since 1.9.0
 */
public class FactoryUtils {
    public static <K, V> void verifyFactoryResult(Map<K, V> factoryResult, Set<K> expectedKeys) {
        // Easy, look for a mismatch
        if (expectedKeys.size() != factoryResult.size()) {
            throw new VCacheException("Factory returned " + factoryResult.size()
                    + " entries when " + expectedKeys.size() + " were expected. Expected keys "
                    + expectedKeys + " but got " + factoryResult.keySet() + ".");
        }

        // Now ensure that the keys align
        final long numberOfUnknownKeys = factoryResult.keySet().stream()
                .filter(k -> !expectedKeys.contains(k))
                .count();
        if (numberOfUnknownKeys > 0) {
            throw new VCacheException("Factory returned the keys " + factoryResult.keySet()
                    + " when expected " + expectedKeys + ".");
        }
    }
}
