package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.core.TransactionControl;

import static com.atlassian.vcache.internal.MetricLabel.TIMED_TRANSACTION_DISCARD_CALL;
import static com.atlassian.vcache.internal.MetricLabel.TIMED_TRANSACTION_SYNC_CALL;
import static java.util.Objects.requireNonNull;

/**
 * Wrapper for a {@link TransactionControl} that records metrics.
 *
 * @since 1.0.0
 */
class TimedTransactionControl implements TransactionControl {
    private final TransactionControl delegate;
    private final MetricsRecorder metricsRecorder;
    private final String cacheName;

    TimedTransactionControl(TransactionControl delegate, MetricsRecorder metricsRecorder, String cacheName) {
        this.delegate = requireNonNull(delegate);
        this.metricsRecorder = requireNonNull(metricsRecorder);
        this.cacheName = requireNonNull(cacheName);
    }

    @Override
    public void transactionSync() {
        try (ElapsedTimer ignored = new ElapsedTimer(
                t -> metricsRecorder.record(cacheName, CacheType.EXTERNAL, TIMED_TRANSACTION_SYNC_CALL, t))) {
            delegate.transactionSync();
        }
    }

    @Override
    public boolean transactionDiscard() {
        try (ElapsedTimer ignored = new ElapsedTimer(
                t -> metricsRecorder.record(cacheName, CacheType.EXTERNAL, TIMED_TRANSACTION_DISCARD_CALL, t))) {
            return delegate.transactionDiscard();
        }
    }
}
