package com.atlassian.vcache.internal;

import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.VCacheException;

import javax.annotation.Nonnull;

/**
 * Specifies the interface for a handler that is called before a cache is created.
 * <p>
 * The implementation is passed the proposed cache details and must return
 * the ultimate cache settings that will be used. None of the returned settings are allowed to be
 * {@link java.util.Optional#empty()}. The implementation should throw a
 * {@link com.atlassian.vcache.VCacheException} if the cache should not be created.
 * </p>
 *
 * @since 1.0.0
 */
public interface VCacheCreationHandler {
    /**
     * Validates the settings for a {@link com.atlassian.vcache.JvmCache}.
     *
     * @param details the proposed details for the cache.
     * @return the complete settings to be used.
     * @throws VCacheException if the cache should not be created
     */
    @Nonnull
    JvmCacheSettings jvmCacheCreation(JvmCacheDetails details) throws VCacheException;

    /**
     * Validates the settings for a {@link com.atlassian.vcache.RequestCache}.
     *
     * @param name the proposed name for the cache.
     * @throws VCacheException if the cache should not be created
     */
    void requestCacheCreation(String name);

    /**
     * Validates the settings for a {@link com.atlassian.vcache.ExternalCache}.
     *
     * @param details the proposed details for the cache.
     * @return the complete settings to be used.
     * @throws VCacheException if the cache should not be created
     */
    @Nonnull
    ExternalCacheSettings externalCacheCreation(ExternalCacheDetails details);
}
