package com.atlassian.vcache.internal;

import javax.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Supplier;

/**
 * Represents the context for a request. Implementations must be thread-safe.
 *
 * @since 1.0.0
 */
public interface RequestContext {
    /**
     * Returns the partition identifier
     *
     * @return the partition identifier
     */
    @Nonnull
    String partitionIdentifier();

    /**
     * Returns the value associated with the specified key, or computes it atomically using the provided
     * supplier.
     *
     * @param key      the key to retrieve the value under.
     * @param supplier the supplier to create the missing value
     * @param <T>      the return type
     * @return the current value associated with the key, or a new value created with the provided supplier.
     */
    @Nonnull
    <T> T computeIfAbsent(Object key, Supplier<T> supplier);

    /**
     * Returns the value associated with the specified key, or {@link java.util.Optional#empty()}.
     */
    @Nonnull
    <T> Optional<T> get(Object key);
}
