package com.atlassian.vcache.internal;

import com.atlassian.json.marshal.Jsonable;

import javax.annotation.Nonnull;
import java.util.function.Function;

/**
 * Represents a factory for building {@link Jsonable} instances for a supplied {@link RequestMetrics}.
 *
 * @since 1.0.0
 */
public interface JsonableFactory extends Function<RequestMetrics, Jsonable> {
    @Override
    @Nonnull
    Jsonable apply(final RequestMetrics requestMetrics);
}
