package com.atlassian.vcache.internal;

import java.util.Map;

/**
 * Represents the metric for a request.
 *
 * @since 1.0
 */
public interface RequestMetrics {
    /**
     * Returns a map of metrics for {@link com.atlassian.vcache.JvmCache} accessed for a request.
     *
     * @return a map, keyed on cache name, to a map of available metrics.
     */
    Map<String, Map<MetricLabel, ? extends LongMetric>> allJvmCacheLongMetrics();

    /**
     * Returns a map of metrics for {@link com.atlassian.vcache.RequestCache} accessed for a request.
     *
     * @return a map, keyed on cache name, to a map of available metrics.
     */
    Map<String, Map<MetricLabel, ? extends LongMetric>> allRequestCacheLongMetrics();

    /**
     * Returns a map of metrics for {@link com.atlassian.vcache.ExternalCache} accessed for a request.
     *
     * @return a map, keyed on cache name, to a map of available metrics.
     */
    Map<String, Map<MetricLabel, ? extends LongMetric>> allExternalCacheLongMetrics();
}
