/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.marshallers;

import com.atlassian.annotations.PublicApi;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.marshallers.JavaSerializationMarshaller;
import com.atlassian.vcache.marshallers.OptionalMarshaller;
import com.atlassian.vcache.marshallers.StringMarshaller;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;

@PublicApi
public class MarshallerFactory {
    @Nonnull
    public static <T> Marshaller<Optional<T>> optionalMarshaller(Marshaller<T> valueMarshaller) {
        return new OptionalMarshaller<T>(valueMarshaller);
    }

    @Nonnull
    public static Marshaller<String> stringMarshaller() {
        return new StringMarshaller();
    }

    @Nonnull
    public static <T extends Serializable> Marshaller<T> serializableMarshaller(Class<T> clazz) {
        return new JavaSerializationMarshaller<T>(clazz);
    }

    @Nonnull
    public static <T extends Serializable> Marshaller<T> serializableMarshaller(Class<T> clazz, ClassLoader loader) {
        return new JavaSerializationMarshaller<T>(clazz, loader);
    }
}

