package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

/**
 * Provides a scale for the rate of change of a measure. For example, the rate of change in the number of entries
 * in a cache.
 *
 * @since 1.0
 */
@PublicApi
public enum ChangeRate {
    /**
     * Indicates that there is no change.
     */
    NONE,
    /**
     * Indicates that there is a low rate of change.
     */
    LOW_CHANGE,
    /**
     * Indicates that there is a high rate of change.
     */
    HIGH_CHANGE
}
