package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

/**
 * Represents an {@link ExternalCache} where both the read and write operations are buffered until
 * the end of a transaction.
 * See the {@link ExternalCache} documentation for more information.
 *
 * @param <V> the value type
 * @since 1.0
 */
@PublicApi
public interface TransactionalExternalCache<V>
        extends ExternalCache<V>, ExternalWriteOperationsBuffered<V> {
}
