package com.atlassian.vcache;

import com.atlassian.annotations.Internal;

import java.util.Optional;

/**
 * Contains utility methods used for settings.
 *
 * @since 1.0.0
 */
@Internal
class SettingsUtils {
    /**
     * Returns the first {@link Optional} if it is present, otherwise returns the second {@link Optional}.
     *
     * @param first  the first {@link Optional} to check
     * @param second the second {@link Optional}
     * @param <T>    the contained type
     * @return <tt>first</tt> if {@link Optional#isPresent()} is {@code true}, otherwise <tt>second</tt>
     */
    static <T> Optional<T> ifPresent(Optional<T> first, Optional<T> second) {
        return first.isPresent() ? first : second;
    }
}
