/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.Watchdog;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class StringInputHandler
implements InputHandler {
    private String encoding;
    private String content;

    public StringInputHandler(String content) {
        this(null, content);
    }

    public StringInputHandler(String encoding, String content) {
        this.encoding = encoding;
        this.content = content;
    }

    @Override
    public void complete() {
    }

    @Override
    public void process(OutputStream input) {
        OutputStreamWriter writer = null;
        try {
            writer = this.encoding == null ? new OutputStreamWriter(input) : new OutputStreamWriter(input, this.encoding);
            writer.write(this.content);
        }
        catch (InterruptedIOException interruptedIOException) {
            IOUtils.closeQuietly(writer);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(writer);
    }

    @Override
    public void setWatchdog(Watchdog watchdog) {
    }
}

