/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;

public class StringOutputHandler
extends BaseOutputHandler {
    private final String encoding;
    private final StringWriter writer;

    public StringOutputHandler() {
        this(null);
    }

    public StringOutputHandler(String encoding) {
        this.encoding = encoding;
        this.writer = new StringWriter();
    }

    public void complete() {
        IOUtils.closeQuietly(this.writer);
    }

    public String getOutput() {
        return this.writer.toString();
    }

    /*
     * Loose catch block
     */
    public void process(InputStream output) throws ProcessException {
        InputStreamReader reader = null;
        try {
            int num;
            reader = this.encoding == null ? new InputStreamReader(output) : new InputStreamReader(output, this.encoding);
            char[] buffer = new char[1024];
            while ((num = reader.read(buffer)) != -1) {
                this.resetWatchdog();
                this.writer.write(buffer, 0, num);
            }
        }
        catch (InterruptedIOException e) {
            IOUtils.closeQuietly(reader);
        }
        catch (IOException e2) {
            throw new ProcessException(e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(reader);
    }
}

